import electric.uddi.AccessPoint;
import electric.uddi.Binding;
import electric.uddi.BusinessInfos;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.IUDDI;
import electric.uddi.IUDDIConstants;
import electric.uddi.Service;
import electric.uddi.TModelInfos;
import electric.uddi.TModelInstance;
import electric.uddi.UDDIException;
import electric.uddi.client.UDDIClient;

public class BusinessService {

	public static void main(String[] args) throws Exception {

		String tModelName = "sw-aviation-xml-org:reservation";
		String businessEntityName = "SW-Air";

		String inquireURL = "";
		String publishURL = "";
		String user = "";
		String password = "";

		// Rcupration des paramtres du registre UDDI.
		if(args.length > 0) {
			inquireURL = args[0];
			publishURL = args[1];
			user = args[2];
			password = args[3];
		}

		if (inquireURL.equals("")) {
			inquireURL = "http://www.sw-registre-uddi.org:8004/glue/inquire/uddi";
		}
		if (publishURL.equals("")) {
			publishURL = "http://www.sw-registre-uddi.org:8006/glue/publish/uddi";
		}
		if (user.equals("")) {
			user = "uddi";
		}
		if (password.equals("")) {
			password = "uddi";
		}

		// Instanciation du client UDDI.
		IUDDI uddi = new UDDIClient(inquireURL, publishURL, user, password);

		// Recherche d'un service type dont le nom est spcifi.
		TModelInfos tModelInfos = uddi.findTModels(tModelName, null);

		// Affichage des informations de chaque service type trouv.
		for(int i = 0; i < tModelInfos.list.length; i++) {
			System.out.println("tModelInfos " + i + " =\n" + tModelInfos.list[i]);
		}

		// Slection de la cl du premier service type.
		String tModelKey = tModelInfos.list[0].getTModelKey();

		// Recherche de la cl de la premire entit mtier dont le nom est spcifi.
		BusinessInfos businessInfos = uddi.findBusinesses(businessEntityName, null);
		String businessKey = businessInfos.list[0].getBusinessKey();
		System.out.println("businessKey = " + businessKey + "\n");

		// Instanciation du service mtier.
		Service service = new Service("Reservation");
		service.setBusinessKey(businessKey);

		// Instanciation d'une liaison pour une implmentation particulire
		// du service de rservation de SW-Air.
		Binding binding = new Binding();
		TModelInstance tModelInstance = new TModelInstance(tModelKey);
		binding.addTModelInstance(tModelInstance);
		Description description = new Description("Access point for the reservation service implementation", "en");
		binding.addDescription(description);
		description = new Description("Point d'accs vers l'implmentation du service de rservation", "fr");
		binding.addDescription(description);
		AccessPoint accessPoint = new AccessPoint("http://www.sw-air.com:8080/reservation_sw-air/servlet/rpcrouter", "http");
		binding.setAccessPoint(accessPoint);

		// Ajout de la liaison au service mtier.
		service.addBinding(binding);

		// Catgorisation du service mtier en "On-Line Information Services" (NAICS).
		Category category = new Category("On-Line Information Services", "514191");
		category.setTModelKey(IUDDIConstants.UDDI_NAICS_UUID);
		service.addCategory(category);

		// Catgorisation du service mtier en "Internet and intranet software" (UNSPSC).
		category = new Category("Internet and intranet software", "431628");
		category.setTModelKey(IUDDIConstants.UDDI_UNSPSC_UUID);
		service.addCategory(category);

		// Ajout des descriptions du service mtier.
		description = new Description("Link to the reservation service", "en");
		service.addDescription(description);
		description = new Description("Lien vers le service de rservation", "fr");
		service.addDescription(description);

		// Publication du service mtier.
		try {
			Service savedService = uddi.saveService(service);
			System.out.println("\nservice mtier publi\n" + savedService);
		}
		catch (UDDIException e) {
			System.out.println("\nune exception " + e + " s'est produite : " + e.getDispositionReport());
		}
	}
}